#include "EventBase.h"
#include <stdio.h>

const char* const EventBase::EventGeneratorNames[numEGIDs] = {
	"UnknownGen",
	"Vision",
	"Button",
	"WorldModel",
	"AI",
	"Audio",
	"Sensor",
	"Power",
	"Timer",
	"StateMachine",
	"Locomotion",
  "TextMsg"
};


EventBase::EventBase()
	: stim_id(""), magnitude(0), timestamp(get_time()), nameisgen(true), genID(unknownEGID), typeID(statusETID), sourceID((unsigned int)-1), duration(0)
{
	genName();
}

EventBase::EventBase(EventGeneratorID_t gid, unsigned int sid, EventTypeID_t tid, unsigned int dur)
	: stim_id(""), magnitude(0), timestamp(get_time()), nameisgen(true), genID(gid), typeID(tid), sourceID(sid), duration(dur)
{
	genName();
	if(tid==deactivateETID)
		setMagnitude(0.0);
	else
		setMagnitude(1.0);
}

EventBase::EventBase(EventGeneratorID_t gid, unsigned int sid, EventTypeID_t tid, unsigned int dur, const std::string& n, float mag)
	: stim_id(n), magnitude(mag), timestamp(get_time()), nameisgen(false), genID(gid), typeID(tid), sourceID(sid), duration(dur)
{
	
}


void EventBase::genName() {
	if(!nameisgen)
		return;
	if(genID<numEGIDs) {
		stim_id="Evt_";
		stim_id+=EventGeneratorNames[genID];
	} else {
		stim_id="Evt_InvalidGen";
		stim_id+=genID; 
	}
	stim_id+="::";
	char tmp[16];
	snprintf(tmp,16,"%x",sourceID);
	stim_id+=tmp;
	/*	switch(genID) {
	case unknownEGID:
		stim_id="Evt_UknownGen::"; break;
	case visionEGID:
		stim_id="Evt_Vision::"; break;
	case buttonEGID:
		stim_id="Evt_Button::"; break;
	case worldModelEGID:
		stim_id="Evt_WorldModel::"; break;
	case aiEGID:
		stim_id="Evt_AI::"; break;
	case audioEGID:
		stim_id="Evt_Audio::"; break;
	case sensorEGID:
		stim_id="Evt_Sensor::"; break;
	case powerEGID:
		stim_id="Evt_Power::"; break;
	case timerEGID:
		stim_id="Evt_Timer::"; break;
	case eventRouterEGID:
		stim_id="Evt_EventRouter::"; break;
	default:
		stim_id="Evt_InvalidGen"; stim_id+=genID; stim_id+="::"; break;
		}*/
	/*	stim_id+=sourceID;*/
	// don't want to do this because it will cause AI to see them as separate stimuli
	/*stim_id+="::";
		switch(typeID) {
		case activateETID:
		stim_id+="act"; break;
		case statusETID:
		stim_id+="stat"; break;
		case deactivateETID:
		stim_id+="deact"; break;
		default:
		stim_id+="inv"; break;
		}*/
}

/*! @file
 * @brief Implements EventBase, the basic class for sending events around the system
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-0_95 $
 * $Revision: 1.7 $
 * $State: Exp $
 * $Date: 2003/03/04 05:46:04 $
 */

