#include "FollowHeadBehavior.h"
#include "Events/EventRouter.h"
#include "Shared/debuget.h"
#include "Shared/WorldState.h"
#include "Motion/MMAccessor.h"
#include "Motion/HeadPointerMC.h"
#include "Motion/WalkMC.h"
#include "Motion/PIDMC.h"

FollowHeadBehavior::FollowHeadBehavior() :
	BehaviorBase(),
	head_release(EventBase::buttonEGID,ChinButOffset,EventBase::activateETID,0),
	head_lock(EventBase::buttonEGID,ChinButOffset,EventBase::deactivateETID,0),
	clock(EventBase::timerEGID,0,EventBase::statusETID,250),
	walker_id(MotionManager::invalid_MC_ID)
{}

FollowHeadBehavior::~FollowHeadBehavior() {
	if(isActive())
		DoStop();
}

void FollowHeadBehavior::DoStart() {
	BehaviorBase::DoStart();
	//set up the shared motions
	walker_id=motman->addMotion(SharedMotion<WalkMC>());
	//register for events and timers
	erouter->addListener(this,head_release);
	erouter->addListener(this,head_lock);
	//prime the head pointer and walk so they're going the right way
	processEvent(head_lock);
	processEvent(clock);
}

void FollowHeadBehavior::DoStop() {
	//remove timers and listeners
	erouter->forgetListener(this);
	//remove motion commands, set them to invalid
	motman->removeMotion(walker_id);
	walker_id=MotionManager::invalid_MC_ID;
	BehaviorBase::DoStop();
}

void FollowHeadBehavior::processEvent(const EventBase& e) {
	if(e==clock) {
		//x,y,a are percentage of maximum speed in that direction
		double x = -(state->outputs[HeadOffset+TiltOffset]/outputRanges[HeadOffset+TiltOffset][1]);
		double y = state->outputs[HeadOffset+RollOffset]/outputRanges[HeadOffset+RollOffset][1];
		double a = state->outputs[HeadOffset+PanOffset]/outputRanges[HeadOffset+PanOffset][1];
		MMAccessor<WalkMC> walk(walker_id);
		walk.mc()->setTargetVelocity(x*WalkMC::MAX_DX,y*WalkMC::MAX_DY,a*WalkMC::MAX_DA);

	} else if(e==head_release) {
		cout << "release" << endl;
		motman->addMotion(SharedMotion<PIDMC>(HeadOffset,HeadOffset+NumHeadJoints,0));
		erouter->addListener(this,clock);

	} else if(e==head_lock) {
		cout << "lock" << endl;
		motman->addMotion(SharedMotion<PIDMC>(HeadOffset,HeadOffset+NumHeadJoints,1));
		for(unsigned int i=HeadOffset; i<HeadOffset+NumHeadJoints; i++)
			motman->setOutput(NULL,i,state->outputs[i]); //doing this prevents the head from jerking back when you released it to where it was before you pressed the button
		cout << state->outputs[HeadOffset+TiltOffset]/M_PI*180 << ' ' << state->outputs[HeadOffset+PanOffset]/M_PI*180 << ' ' << state->outputs[HeadOffset+RollOffset]/M_PI*180 << endl;
		erouter->removeListener(this,clock);

	} else {
		ASSERT(false,"unprocessed event " << e.getName() << endl);
	}
}

/*! @file
 * @brief Implements FollowHeadBehavior, walks where the head is pointing
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2003/03/04 05:46:04 $
 */

