#ifndef INCLUDED_SaveAIControl_h
#define INCLUDED_SaveAIControl_h

#include "../ControlBase.h"
#include "../../ai/Model.h"

//!When activated, prompts for a filename and saves the AI into that
class SaveAIControl : public ControlBase {
 public:
	//!constructor, designates which model to save
	SaveAIControl(const stringet& n, Model* m) : ControlBase(n), model(m) {}
	//!destructor
	virtual ~SaveAIControl() {}

	virtual ControlBase * activate(MotionManager::MC_ID display) {
		char cur[33];
		cout << "#> " << flush;
		cin >> cur;
		cout << endl;
		if(strlen(cur)>0) {
			stringet path("/MS/data/ai/");
			path+=cur;
			model->SaveFile(path.c_str());
		}
		return NULL;
	}

 protected:
	Model* model; //!< the model to save
};

/*! @file
 * @brief Defines SaveAIControl, which saves AI models into files
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-0_95 $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2003/03/01 20:53:29 $
 */

#endif
