#ifndef INCLUDED_LoadAIControl_h
#define INCLUDED_LoadAIControl_h

#include "ControlBase.h"
#include "AI/Model.h"

//!When activated, prompts for a filename and loads that into the AI
class LoadAIControl : public ControlBase {
 public:
	//!constructor, designates which model to load files into
	LoadAIControl(const stringet& n, Model* m) : ControlBase(n), model(m) {}
	//!destructor
	virtual ~LoadAIControl() {}

	virtual ControlBase * activate(MotionManager::MC_ID display) {
		char cur[33];
		cout << "#> " << flush;
		cin >> cur;
		cout << endl;
		if(strlen(cur)>0) {
			stringet path("/MS/data/ai/");
			path+=cur;
			model->LoadFile(path.c_str());
		}
		return NULL;
	}

 protected:
	Model* model; //!< the model to load files into
};

/*! @file
 * @brief Defines LoadAIControl, loads saved files into AI models
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-0_95 $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2003/03/01 20:53:28 $
 */

#endif
