#include "WorldModel.h"
#include "WorldModelSerializer.h"
#include "Shared/Config.h"
#include "Shared/get_time.h"
#include <string.h>

WorldModelSerializer::WorldModelSerializer() : wmGrid(NULL), wmLoc(NULL) {
  wmGrid=wireless->socket(SocketNS::SOCK_STREAM, 1024, 1024);
  wmLoc=wireless->socket(SocketNS::SOCK_STREAM, 1024, 1024);
  wireless->listen(wmGrid->sock, config->worldmodel.grid_port);
  wireless->listen(wmLoc->sock, config->worldmodel.loc_port);
}

void
WorldModelSerializer::serializePos() {
  char *buf=(char*)wmLoc->getWriteBuffer(40);
  if (buf) {
    encodePos((char *)buf,wmodel->_posX,wmodel->_posY,wmodel->_sdev,
		          wmodel->_bodyOrient,wmodel->_adev);
    wmLoc->write(40);
  }
}

void
WorldModelSerializer::serializeGrid() {
  char *buf=(char*)wmGrid->getWriteBuffer(30*30);
  if (buf) {
    encodeGrid((char *)buf,(char *)wmodel->_cells);
    wmGrid->write(30*30);
  }
}

void
WorldModelSerializer::encodePos(char *buf, double x, double y,
		  double xydev, double theta, double thetadev) {
  encode(&buf, x);
  encode(&buf, y);
  encode(&buf, xydev);
  encode(&buf, theta);
  encode(&buf, thetadev);
}

void
WorldModelSerializer::encodeGrid(char *buf, char *grid) {
  memcpy(buf,grid,30*30);
}
