#ifndef INCLUDED_WorldModel_h
#define INCLUDED_WorldModel_h

#include "WorldCell.h"
#include "WorldObject.h"
#include "Motion/MotionManager.h"
#include "Shared/WorldStateSerializer.h"

class Vision;
struct Marker;

#define DIR_RIGHT 1
#define DIR_LEFT -1

struct WMMarker {
  int cen_x;
  int cen_y;
  int marker;
};

class WorldModelSerializer;

class WorldModel{
  friend class WorldModelSerializer;
public:
  WorldModel();
  void initialize();
  void localize();
  void abortLocalize();
  void reportMarkers(Marker* markers, int num_markers);
  void close();
  void frameProcessor();
  
  void reportObject(unsigned int obj);
  void removeObject(unsigned int obj);

  static const int _num_markers=12;

  // precalculated world information
  static const double _marker_x[_num_markers];
  static const double _marker_y[_num_markers];

  static const double _poolRadius;

  enum LocalizationState_t {
    loc_disabled,
    loc_enabled,
    loc_moveto1,
    loc_center1,
    loc_wait1,
    loc_moveto2,
    loc_center2,
    loc_wait2,
    loc_done
  };

  LocalizationState_t _locState;

  
private:
  void slowLocalizationSM();
  void localizationSM();
  int markerClosestToCenter();
  const char* markerToString(int mkr);
  void moveHeadRadians(double tilt, double pan, double roll);
  void moveHeadAbsRadians(double tilt, double pan, double roll);
  void moveHead(int tilt, int pan, int roll);
  void moveHeadScreen(int x, int y);
  int markerDistance(int marker1, int marker2);
  bool fitToCircle(int accuracy[], double distance[], double angle[]);
  bool triangulate(int marker1, double distance1, int marker2, double distance2, double results[],int pos);
  bool updatePosition2(int numSamples, double positions[]);
  bool updatePosition(int marker1, double distance1, int marker2, double distance2);
  bool updateOrientation(int marker, double markerangle);
//  bool updateOrientation2(int numSamples, double positions[], int markers[], double angle[]);
  bool updateOrientation2(int numValid, int markers[], double angle[]);

  int _numMarkers;
  WMMarker _markers[3];
  
  double _posX;
  double _posY;
  double _sdev;
  double _bodyOrient;
  double _adev;

  int _centerX, _centerY;

  WorldModelSerializer* wmser;

  char _cells[30][30];
  WorldObject _objects[10]; 
  int _numobjs;

  MotionManager::MC_ID headpointer_id;
};

extern WorldModel* wmodel;
#endif
