#ifndef INCLUDED_WorldCell_h
#define INCLUDED_WorldCell_h

#include <stdio.h>
#include "WorldObject.h"

class WorldCell {
  public:
    WorldCell() {
      _object=NULL;
      _probability=0.0;
      _lastseen=0;
    }
    void empty(int timestamp) { 
      _object=NULL;
      _probability=1.0;
      _lastseen=timestamp;
    }

    int getSeen() { return _lastseen; }
    WorldCell& setSeen(int timestamp) { _lastseen=timestamp; return *this; }

    WorldObject* getObject() { return _object; }
    WorldCell& setObject(WorldObject* object) { _object=object; return *this; }
    
    double getProb() { return _probability; }
    WorldCell& setProb(double prob) { _probability=prob; return *this; }
    
  private:
    WorldObject *_object;
    double _probability;
    unsigned int _lastseen;
};

#endif
