#ifndef Socket_h_DEFINED
#define Socket_h_DEFINED

#include <ant.h>
#include <Types.h>
#include <stdarg.h>

namespace SocketNS {
  enum TransportType_t {
    SOCK_STREAM=0,
    SOCK_DGRAM
  };

  enum ConnectionState {
    CONNECTION_CLOSED,
    CONNECTION_CONNECTING,
    CONNECTION_CONNECTED,
    CONNECTION_LISTENING,
    CONNECTION_CLOSING,
    CONNECTION_ERROR
  };
};

using namespace SocketNS;

class Wireless;
extern Wireless* wireless;


class Socket {
  friend class Wireless;

public:
  int sock;

public:
  Socket(int sockn) : sock(sockn), trType(), endpoint(), state(CONNECTION_CLOSED),
    sendBufSize(), recvBufSize(), sendSize(0), recvSize(0), writeSize(0),
    readSize(0), tx(false), rx(false), sendBuffer(), recvBuffer(),
		sendData(NULL), recvData(NULL),
    readData(NULL), writeData(NULL), server_port(0), rcvcbckfn(NULL)
    { }

  byte* getWriteBuffer();
  byte* getWriteBuffer(int bytesreq);
  byte* getReadBuffer();
  void write(int size);
  int read();
  void init();
  void flush();
  void hard_flush();
  int write(byte *buf, int size);
  int read(byte *buf, int size);
  int printf(const char *fmt, ...);
  int perror(const char *fmt, ...);
  int pdebug(int dlevel, const char *fmt, ...);
  int pprintf(int vlevel, const char *fmt, ...);

private:
  TransportType_t trType;

  antModuleRef endpoint;
  ConnectionState state;

  int sendBufSize, recvBufSize, sendSize, recvSize, writeSize, readSize;
  bool tx, rx;

  antSharedBuffer sendBuffer, recvBuffer;
  byte *sendData, *recvData;
  byte *readData, *writeData;
  int server_port;
  int (*rcvcbckfn) (char*, int);
 
private:
  Socket(const Socket&);
  Socket& operator= (const Socket&);
};

extern Socket* sout;
extern Socket* serr;
#endif
