#ifndef INCLUDED_VisionSerializer_h
#define INCLUDED_VisionSerializer_h

#include "Vision.h"
#include "VisionInterface.h"
#include "Shared/Serializer.h"

class VisionSerializer : public Serializer {
public:
  VisionSerializer();
  void serialize();
  
private:
  void encodeVisionRaw(char *buf,CMVision::image_yuv<const uchar> &img,
                       int scale);
  void encodeVisionRLE(char *buf,int num_runs,run *runs);
  inline char* encodeVisionRun(char *buf, run *run);

  VisionSerializer(const VisionSerializer&);
  VisionSerializer& operator= (const VisionSerializer&);

  Socket *visRaw;
  Socket *visRLE;
};

#endif
