//-*-c++-*-
#ifndef INCLUDED_OutputNode_h_
#define INCLUDED_OutputNode_h_

#include "StateNode.h"
#include <string>
#include <ostream>

//! A very simple StateNode that outputs its name to a given ostream upon activation, handy for debugging
class OutputNode : public StateNode {
public:
	//!constructor, uses cout for output
	OutputNode() : StateNode(), next(NULL), out(cout) {}
	//!constructor, sets name and ostream to use for output
	OutputNode(const char* nm, StateNode* par, ostream& output) : StateNode(nm,par), next(NULL), out(output) {}
	//!constructor, sets name and another state which will immediately be transitioned to upon activation
	OutputNode(const char* nm, StateNode* par, ostream& output, StateNode * nextstate) : StateNode(nm,par), next(nextstate), out(output) {}

	//!outputs this state's name, will transition to #next if non-NULL
	/*!if #next is NULL, the state will simply stay active until some other transition causes it to leave*/
	virtual void DoStart() {
		StateNode::DoStart();
		out << name << endl;
		DoStop();
		if(next!=NULL)
			next->DoStart();
	}
	
protected:
	StateNode* next; //!< the state to transition to upon entering, can be NULL
	ostream& out;    //!< the stream to use for output - if not specified (default constructor) cout will be used

private:
	OutputNode(const OutputNode& node); //!< don't call this
	OutputNode operator=(const OutputNode& node); //!< don't call this
};

/*! @file
 * @brief Defines OutputNode, a very simple StateNode that outputs its name to a given ostream upon activation, handy for debugging
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name:  $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2003/01/10 05:08:15 $
 */

#endif
