//-*-c++-*-
#ifndef INCLUDED_ReferenceCounter_h_
#define INCLUDED_ReferenceCounter_h_

#include <iostream>

//! Performs simple reference counting, will delete the object when removing the last reference
class ReferenceCounter {
 public:
	//! constructor
	ReferenceCounter() : references(0) {}

	//! destructor - will std::cout a warning if still has references
	virtual ~ReferenceCounter() {
		if(references>0)
			std::cout << "*** WARNING RefCounter was deleted with " << references << " references" << std::endl;
	}

	//! adds one to references
	virtual void AddReference() { references++; }
	//! subtracts one from references AND DELETES the object IF ZERO
	virtual void RemoveReference() {
		if(--references==0)
			delete this;
		else if(references==(unsigned int)-1)
			std::cout << "*** WARNING RefCounter went negative" << std::endl;
	}
	//! returns the number of references
	/*! @return references */
	virtual unsigned int GetReferences() { return references; }
	
 protected:
	//! the current number of references
	unsigned int references;
};


/*! @file
 * @brief Defines the ReferenceCounter base class, which allows for automatic memory deallocation
 * @author ejt (Creator)
 *
 * $Author: alokl $
 * $Name:  $
 * $Revision: 1.1.1.1 $
 * $State: Exp $
 * $Date: 2002/09/30 18:19:48 $
 */

#endif

