//-*-c++-*-
#ifndef INCLUDED_TailWagMC_h
#define INCLUDED_TailWagMC_h

#include "MotionCommand.h"
#include "Shared/get_time.h"
#include "math.h"

//! A simple motion command for wagging the tail - you can specify period, magnitude, and tilt
class TailWagMC : public MotionCommand {
 public:
	//!constructor
	TailWagMC() : period(500), magnitude(22*3.141592/180), active(false), last(), tilt() {/* RegInit();*/ setAutoPrune(false); }
	//!destructor
	virtual ~TailWagMC() {}
	virtual int updateJointCmds() {
		if(active) {
			last.set(sin((6.2831853*get_time())/period)*magnitude,1);
			return 1;
		} else
			return 0;
	}
	virtual inline const JointCmd& getJointCmd(unsigned int i) {
		if(!active)
			return unusedJoint;
		if(i==TailOffset+PanOffset)
			return last;
		if(i==TailOffset+TiltOffset)
			return tilt;
		return unusedJoint;
	}
	virtual int isDirty() { return active; }
	virtual int isAlive() { return active; }

	void setPeriod(unsigned int p) { period=p; } //!< sets the period of time between swings, in milliseconds
	unsigned int getPeriod() { return period; } //!< gets the period of time between swings, in milliseconds
	void setMagnitude(double mag) { magnitude=mag; } //!< sets the magnitude of swings, in radians
	double getMagnitude() { return magnitude; } //!< gets the magnitude of swings, in radians
	void setTilt(double r) { tilt.set(r,1); }  //!< sets the tilt of the tail while wagging, in radians
	void unsetTilt() { tilt=unusedJoint; } //!< makes the tilt control unspecified, will let something else control tilt
	double getTilt() { return tilt.value; }  //!< sets the tilt of the tail while wagging, in radians
	void setActive(bool a) { active=a; } //!< turns the tail wagger on or off
	bool getActive() { return active; } //!< returns true if this is currently trying to wag the tail
	
 protected:
	unsigned int period; //!< period of time between swings, in milliseconds
	double magnitude; //!< magnitude of swings, in radians
	bool active; //!< true if this is currently trying to wag the tail
	JointCmd last; //!< holds last position we set the tail to
	JointCmd tilt; //!< holds current setting for the tilt joint
	//	REGDEF(TailWagMC,MotionCommand,period,tilt);
};

#endif

