//-*-c++-*-
#ifndef INCLUDED_MotionManagerMsg_h
#define INCLUDED_MotionManagerMsg_h

#include <OPENR/RCRegion.h>

//! A small header that preceeds data sent by MotionManager between processes
struct MotionManagerMsg {
	typedef unsigned short MC_ID; //!< the type to use when referring to MotionCommand ID's
	static const unsigned int SIZEOF_MSG=8; //!< size of header @warning not necessarily size of MotionManagerMsg - be careful if you change this! (need to keep multiple of 8)

	//! Denotes what type of message this is
	enum MsgType { addMotion, deleteMotion } type;
	
	//! The id of the MotionCommand this is in reference to
	MC_ID mc_id;

	//! Sets up the header as an add motion message
	void setAdd(MC_ID id) {
		type=addMotion;
		mc_id=id;
	}

	//! Sets up the header as an erase motion message
	void setDelete(MC_ID id) {
		type=deleteMotion;
		mc_id=id;
	}

};

/*! @file
 * @brief Defines MotionManagerMsg, a small header used by MotionManager for sending messages between processes
 * @author ejt (Creator)
 *
 * $Author: alokl $
 * $Name:  $
 * $Revision: 1.1.1.1 $
 * $State: Exp $
 * $Date: 2002/09/30 18:19:50 $
 */

#endif // INCLUDED_MotionManagerMsg_h
