//-*-c++-*-
#ifndef INCLUDED_LedMC_h
#define INCLUDED_LedMC_h

#include "MotionCommand.h"
#include "LedEngine.h"

//! This is just a simple wrapper - you probably want to be looking at LedEngine.h
/*! This is handy if all you want to do is control the LED's, but since other
 *  MotionCommands will probably also want to make use of the LEDs, they can
 *  just use the engine component to do all the work. */
class LedMC : public MotionCommand, public LedEngine {
 public:
	//! constructor
	LedMC() : MotionCommand(), LedEngine() { /*RegInit();*/ setWeight(~0,1); }
	//! destructor
	virtual ~LedMC() {}

	//! updates the cmds from LedEngine::updateLEDs()
	virtual int updateJointCmds() { return updateLEDs(cmds); }
	//! plans ahead frames (a little smarter than just duplicating current, better blinking
	virtual void planJointCmds(unsigned int i, JointCmd frames[NumFrames]) {
		if(i>=LEDOffset && i<LEDOffset+NumLEDs) {
			unsigned int t=get_time();
			for(unsigned int f=0; f<NumFrames; f++)
				frames[f].set(calcValue(i-LEDOffset,t+f*FrameTime),1);
		}
	}
	virtual inline const JointCmd& getJointCmd(unsigned int i) { return isUsingOutput(i)?cmds[i-LEDOffset]:unusedJoint; }
	virtual int isDirty() { return LedEngine::isDirty(); }
	virtual int isAlive() { return true; } //!< @todo let's make this smarter so you can flash the LED's and have it autoprune
	virtual bool isUsingOutput(unsigned int i) { return (i>=LEDOffset && i<LEDOffset+NumLEDs); }

	//! Sets the JointCmd::weight of the LEDs specified by @a leds to @a weight
	void setWeight(LEDBitMask_t leds, double weight) {
		for(unsigned int i=0; i<NumLEDs; i++)
			if((leds>>i)&1)
				cmds[i].weight=weight;
	}
	
 protected:
	//! stores current values of LEDs
  JointCmd cmds[NumLEDs];

	/*	REGDEFCUSTOMMEM(LedMC) {
		MotionCommand::registerDataRegions(regions);
		registerRegion(regions,&infos,&dirtyTime,sizeof(dirtyTime)); //for LedEngine
		registerRegion(regions,&cmds,&cmds,sizeof(cmds));
		}*/
};

/*!@file
 * @brief Defines LedMC, which provides a basic MotionCommand wrapper to LedEngine
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name:  $
 * $Revision: 1.3 $
 * $State: Exp $
 * $Date: 2003/02/23 09:58:14 $
 */

#endif

// Another way of doing things (this style for everyone else, look at EmergencyStopMC for instance
// But for the main LedMC, this gets out of sync when i change the engine, so i just use inheritance
/* 
class LedMC : public MotionCommand, public LedEngine {
 public:
	LedMC() : MotionCommand() {MCInit(); setPriority(kLowPriority); setWeight(~0,1); }
	virtual int updateJointCmds() { return engine.updateLEDs(cmds); }
	virtual inline const JointCmd& getJointCmd(unsigned int i) { return (i>=LEDOffset && i<LEDOffset+NumLEDs)?cmds[i-LEDOffset]:unusedJoint; }
	virtual int isDirty() { return engine.isDirty(); }
	virtual int isAlive() { return true; }

	void invert(LEDBitMask_t leds) { engine.invert(leds); }
	void cset(LEDBitMask_t leds, double value) { engine.cset(leds,value); }
	void set(LEDBitMask_t leds, double value) { engine.set(leds,value); }
	void cflash(LEDBitMask_t leds, unsigned int ms=500) { engine.cflash(leds,ms); }
	void flash(LEDBitMask_t leds, unsigned int ms=500) { engine.flash(leds,ms); }
	void ccycle(LEDBitMask_t leds, unsigned int period, double amp, int offset=0) { engine.ccycle(leds,period,amp,offset); }
	void cycle(LEDBitMask_t leds, unsigned int period, double amp, int offset=0) { engine.cycle(leds,period,amp,offset); }
	void clear() { engine.clear(); }
	void setWeight(LEDBitMask_t leds, double weight) {
		for(unsigned int i=0; i<NumLEDs; i++)
			if((leds>>i)&1)
				cmds[i].weight=weight;
	}
	
	double getSetting(LEDOffset_t led_id) { return engine.getSetting(led_id); }
	double getValue(LEDOffset_t led_id) { return engine.getValue(led_id); }

 protected:
	static unsigned int crID;
	virtual void setClassRegistrationID(unsigned int id) { crID=id; }
	virtual unsigned int getClassRegistrationID() const { return crID; }

	LedEngine engine;

  JointCmd cmds[NumLEDs];
};
*/
