#include "HeadPointerMC.h"
#include "Shared/debuget.h"
#include "Shared/WorldState.h"
#include <math.h>

//REGIMP(HeadPointerMC);

HeadPointerMC::HeadPointerMC() :
	MotionCommand(), dirty(true), active(true) {
	//	RegInit();
	setAutoPrune(false);
	setWeight(1);
	for(unsigned int i=0; i<NumHeadJoints; i++) {
		headModes[i]=BodyRelative;
		headValues[i]=0;
	}
}

void HeadPointerMC::setJoints(double tilt, double pan, double roll) {
	headValues[TiltOffset]=tilt;
	headValues[PanOffset]=pan;
	headValues[RollOffset]=roll;
	dirty=true;
}

void HeadPointerMC::setWeight(double w) {
	for(unsigned int x=0; x<NumHeadJoints; x++)
		headJoints[x].weight=w;
	dirty=true;
}

void HeadPointerMC::setMode(CoordFrame_t m, bool conv) {
	for(unsigned int x=0; x<NumHeadJoints; x++)
		setJointMode((RobotInfo::TPROffset_t)x,m,conv);
}

void HeadPointerMC::setJointMode(RobotInfo::TPROffset_t i, CoordFrame_t m, bool conv) {
	if(conv)
		headValues[i]=HeadPointerMC::convert(i,headValues[i],headModes[i],m);
	headModes[i]=m;
	dirty=true;
}

int HeadPointerMC::updateJointCmds() {
	int tmp=isDirty();
	if(tmp) {
		dirty=false;
		for(unsigned int i=0; i<NumHeadJoints; i++)
			if(headModes[i]!=BodyRelative) {
				headJoints[i].value=convToBodyRelative((RobotInfo::TPROffset_t)i,headValues[i],headModes[i]);
				dirty=true;
			} else
				headJoints[i].value=headValues[i];
	}
	return tmp;
}

const JointCmd& HeadPointerMC::getJointCmd(unsigned int i) {
	i-=HeadOffset;
	if(i<NumHeadJoints && getActive())
		return headJoints[i];
	else
		return unusedJoint;
}

void HeadPointerMC::planJointCmds(unsigned int i, JointCmd frames[NumFrames]) {
	i-=HeadOffset;
	if(i<NumHeadJoints && getActive())
		for(unsigned int f=0; f<NumFrames; f++)
			frames[f]=headJoints[i];
	else
		for(unsigned int f=0; f<NumFrames; f++)
			frames[f]=unusedJoint;
}

bool HeadPointerMC::isUsingOutput(unsigned int i) {
	i-=HeadOffset;
	if(i<NumHeadJoints && getActive())
		return (headJoints[0].weight>0);
	return false;
}

/*! @todo this is perhaps a bit amateurish - could be more accurate */
double HeadPointerMC::convToBodyRelative(RobotInfo::TPROffset_t i, double v, CoordFrame_t mode) const {
	switch(mode) {
	default:
		ASSERT(false,"Passed bad mode "<<mode);
	case BodyRelative:
		return v;
	case GravityRelative: {
		double bacc=state->sensors[BAccelOffset];
		double lacc=state->sensors[LAccelOffset];
		double dacc=state->sensors[DAccelOffset];
		switch(i) {
		case TiltOffset:
			return v+atan2(bacc,sqrt(dacc*dacc+lacc*lacc));
		case PanOffset:
			return v;
		case RollOffset:
			return v+atan2(-lacc,sqrt(dacc*dacc+bacc*bacc));
		default:
			ASSERT(false,"Passed bad offset "<<i<<" (use RobotInfo::TPROffset_t!)");
			return v;
		}
	}
	}
}

/*! @todo this is perhaps a bit amateurish - could be more accurate */
double HeadPointerMC::convFromBodyRelative(RobotInfo::TPROffset_t i, double v, CoordFrame_t mode) const {
	switch(mode) {
	default:
		ASSERT(false,"Passed bad mode "<<mode);
	case BodyRelative:
		return v;
	case GravityRelative: {
		double bacc=state->sensors[BAccelOffset];
		double lacc=state->sensors[LAccelOffset];
		double dacc=state->sensors[DAccelOffset];
		switch(i) {
		case TiltOffset:
			return v-atan2(bacc,sqrt(dacc*dacc+lacc*lacc));
		case PanOffset:
			return v;
		case RollOffset:
			return v-atan2(-lacc,sqrt(dacc*dacc+bacc*bacc));
		default:
			ASSERT(false,"Passed bad offset "<<i<<" (use RobotInfo::TPROffset_t!)");
			return v;
		}
	}
	}
}

