#include "EmergencyStopMC.h"
#include "Shared/WorldState.h"
#include "Shared/get_time.h"
//#include "../../headers/CircBufPacket.h"

//extern PacketStream *TextOutputStream;

//REGIMP(EmergencyStopMC);

EmergencyStopMC::EmergencyStopMC()
	: PostureMC(), paused(false), stilldown(false), active(true), period(5000),
		timeoflastbtn(0), timeofthisbtn(0), duration(600),
		pidcutoff(static_cast<unsigned char>(0.16*255)), ledengine()
{
	/*RegInit();*/
	setPriority(kEmergencyPriority);
	setAutoPrune(false);
	for(unsigned int i=0; i<NumPIDJoints; i++)
		piddutyavgs[i]=0;
}


int EmergencyStopMC::updateJointCmds() {
	if(state->button_times[BackButOffset]) {
		if(!stilldown) {
			stilldown=true;
			timeoflastbtn=timeofthisbtn;
			timeofthisbtn=get_time();
			//			cout << "Press " << timeofthisbtn << ' ' << timeoflastbtn << endl;
		}
		//		cout << "Down" << endl;
	} else if(stilldown) {
		//		cout << "Release " << get_time() << endl;
		stilldown=false;
		if((get_time()-timeoflastbtn)<duration)
			setStopped(!paused);
	}
	if(paused) {
		for(unsigned int i=0; i<NumPIDJoints; i++) {
			piddutyavgs[i]=static_cast<unsigned char>(piddutyavgs[i]*.8+fabs(state->pidduties[i])*255*.2);
			if(piddutyavgs[i]>pidcutoff) {
				cmds[i].value-=state->pidduties[i]/10;
				//				cmds[i].value=state->outputs[i];
				//				cout << outputNames[i] << ' ' << state->pidduties[i] << ' ' << state->outputs[i] << endl;
			}
		}
	}
	if(isDirty()) {
		ledengine.updateLEDs(&cmds[LEDOffset]);
		if(!paused)
			dirty=false;
		return 1;
	}
	return 0;
}

void EmergencyStopMC::setActive(bool a) {
	if(paused) {
		if(!a && active)
			releaseJoints();
		else if(a && !active)
			freezeJoints();
	}
	active=a;
}


void EmergencyStopMC::setStopped(bool p) {
	if(p!=paused) {
		paused=p;
		if(active) {
			dirty=true;
			if(paused) {
				freezeJoints();
				//			pprintf(TextOutputStream,"*** PAUSED ***\n");
				cout << "*** PAUSED ***" << endl;
			} else {
				releaseJoints();
				//			pprintf(TextOutputStream,"*** UNPAUSED ***\n");
				cout << "*** UNPAUSED ***" << endl;
			}
		}
	}
}

void EmergencyStopMC::freezeJoints() {
	takeSnapshot();
	for(unsigned int i=LEDOffset; i<LEDOffset+NumLEDs; i++)
		cmds[i]=unusedJoint; // let other commands' LEDs "show through"

	cmds[TlRedLEDOffset].set(state->outputs[TlRedLEDOffset],1);
	cmds[TlBluLEDOffset].set(state->outputs[TlBluLEDOffset],1);
	if(state->outputs[TlRedLEDOffset]>.5) // this will pulse from current value, down if already high, up if already low
		ledengine.cycle(TlRedLEDMask,period,-.5,state->outputs[TlRedLEDOffset]-.75,period/2);
	else
		ledengine.cycle(TlRedLEDMask,period,.5,state->outputs[TlRedLEDOffset]-.25);
	if(state->outputs[TlBluLEDOffset]>.5) // this will pulse from current value, down if already high, up if already low
		ledengine.cycle(TlBluLEDMask,period,-.5,state->outputs[TlBluLEDOffset]-.75);
	else
		ledengine.cycle(TlBluLEDMask,period,.5,state->outputs[TlBluLEDOffset]-.25,period/2);
}

void EmergencyStopMC::releaseJoints() {
	for(unsigned int i=0; i<NumOutputs; i++)
		cmds[i]=unusedJoint;
}

/*! @file
 * @brief Implements EmergencyStopMC, overrides all joints, allows modelling, blinks tail
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name:  $
 * $Revision: 1.5 $
 * $State: Exp $
 * $Date: 2003/02/07 04:04:27 $
 */

/*void EmergencyStopMC::takeSnapshot() {
	for(unsigned int i=0; i<NumOutputs; i++)
		cmds[i].set(state->outputs[i],1);
	dirty=true;
}

EmergencyStopMC& EmergencyStopMC::setJointCmd(unsigned int i, const JointCmd& c) {
	cmds[i]=c;
	dirty=true;
	return *this;
}

EmergencyStopMC& EmergencyStopMC::setJointCmd(unsigned int i, double value, double weight) {
	cmds[i].set(value,weight);
	dirty=true;
	return *this;
}

int EmergencyStopMC::loadFile(const char* name) {
	const unsigned int bufsize=256;
	char buf[bufsize];
	strncpy(buf,"/ms/config/motion/",255);
	strncat(buf,name,255);
	cout << "Loading: " << buf << endl;
	for(unsigned int i=0; i<NumOutputs; i++)
		cmds[i]=unusedJoint;
	dirty=true;
	HFS::FILE* f = HFS::fopen(buf,"r");
	if(f==NULL) {
		cout << "*** WARNING could not open file for loading \"" << buf << "\"" << endl;
		return 0;
	}
	char formatstring[64];
	sprintf(formatstring,"%%%dc %%f %%f",outputNameLen);
	cout << "Format: " << formatstring << endl;
	unsigned int idx=0;
	while(HFS::fgets(buf,bufsize,f)) {
		char jname[outputNameLen+1];
		float fval, fwht;
		if(buf[0]=='#')
			continue;
		sscanf(buf,formatstring,jname,&fval,&fwht);
		jname[outputNameLen]='\0';
		cout << '"' << jname << "\"\t" << (double)fval << '\t' << (double)fwht << endl;
		unsigned int startidx=idx;
		for(;idx<NumOutputs;idx++)
			if(strcmp(jname,outputNames[idx])==0) {
				cmds[idx].set(fval,fwht);
				break;
			}
		if(idx==NumOutputs) {
			for(idx=0;idx<startidx;idx++)
				if(strcmp(jname,outputNames[idx])==0) {
					cmds[idx].set(fval,fwht);
					break;
			}
			if(idx==startidx && strcmp(jname,outputNames[idx])!=0)
				cout << "*** WARNING unmatched jointName: " << jname << endl;
		}
	}
	HFS::fclose(f);
	return 1;
}

int EmergencyStopMC::saveFile(const char* name) {
	const unsigned int bufsize=255;
	char buf[bufsize];
	strncpy(buf,"/ms/config/motion/",255);
	strncat(buf,name,255);
	cout << "Saving: " << buf << endl;
	HFS::FILE* f = HFS::fopen(buf,"w");
	if(f==NULL) {
		cout << "*** WARNING could not open file for saving \"" << buf << "\"" << endl;
		return 0;
	}
	char * header=NULL;
	sprintf(header,"# Remember to pad all joint names with spaces (reads %d chars per name)",outputNameLen);
	HFS::fwrite(header,sizeof(char),strlen(header),f);
	for(unsigned int i=0; i<NumOutputs; i++)
		if(cmds[i].weight!=0) {
			unsigned int len=sprintf(buf,"%s\t% .3f\t%.3f\n",outputNames[i],cmds[i].value,cmds[i].weight);
			HFS::fwrite(buf,sizeof(char),len,f);
		}
	HFS::fclose(f);
	return 1;
}
*/
// previous style
/*
int EmergencyStopMC::updateJointCmds() {
	if(state->buttonPress(BackButOffset)) {
		if(!stilldown) {
			stilldown=true;
			timeoflastbtn=timeofthisbtn;
			timeofthisbtn=get_time();
			//cout << "Press " << timeofthisbtn << ' ' << timeoflastbtn << endl;
		}
		//cout << "Down" << endl;
	} else if(stilldown) {
		//cout << "Release " << get_time() << endl;
		stilldown=false;
		if((get_time()-timeoflastbtn)<duration)
			setStopped(!paused,sd);
	}
	if(isDirty(sd)) {
		if(paused) {
			unsigned int period = 2000;
			bool test = ((get_time()/(period))&1);
			if(test!=LEDon) {
				LEDon=test;
				if(LEDon) {
					cmds[TlBluLEDOffset]=unusedJoint; // turn *transparent* between blinks, not just "off"
					cmds[TlRedLEDOffset].set(state->outputs[TlRedLEDOffset],1);
					if(state->outputs[TlRedLEDOffset]>.5) // this will pulse from current value, down if already high, up if already low
						ledengine.cycle(TlRedLEDMask,period,-.5,state->outputs[TlRedLEDOffset]-.75);
					else
						ledengine.cycle(TlRedLEDMask,period,.5,state->outputs[TlRedLEDOffset]-.25);
				} else {
					cmds[TlBluLEDOffset].set(state->outputs[TlBluLEDOffset],1);
					cmds[TlRedLEDOffset]=unusedJoint; // turn *transparent* between blinks, not just "off"
					if(state->outputs[TlBluLEDOffset]>.5) // this will pulse from current value, down if already high, up if already low
						ledengine.cycle(TlBluLEDMask,period,-.5,state->outputs[TlBluLEDOffset]-.75);
					else
						ledengine.cycle(TlBluLEDMask,period,.5,state->outputs[TlBluLEDOffset]-.25);
				}
			}
			ledengine.updateLEDs(&cmds[LEDOffset]);
		} else
			dirty=false;
		return 1;
	}
	return 0;
}
*/
