#ifndef INCLUDED_VisionEvent_h
#define INCLUDED_VisionEvent_h

#include "EventBase.h"

//! contains source IDs for the objects we can recognize
namespace VisionEventNS {
	//! contains source IDs for the objects we can recognize
  enum VisionSourceID_t {
    RedBallSID=0, //!< a red bean bag ball
    PinkBallSID,  //!< the plastic pink ball Aibos ship with
    HandSID,      //!< Optimized for Ethan's hand, a pasty white thing.
    ThumbsupSID,  //!< Recognizes when Ethan is giving a thumbs up.
    ThingSID,     //!< Other stuff
    MarkersSID    //!< never actually generated: data directly
                  //!  reported to WorldModel
  };
}

//! Extends EventBase to also include location in the visual field and distance (though distance is not implimented yet)
class VisionEvent : public EventBase {
 public:
	//! Constructor
  VisionEvent() : EventBase(EventBase::visionEGID,(unsigned int)-1,EventBase::statusETID,0),_cenX(0),_cenY(0),_distance(),_property(-1) {}
	//! Constructor, pass a type id and source id
  VisionEvent(EventTypeID_t tid, unsigned int sid) : EventBase(EventBase::visionEGID,sid,tid,0),_cenX(0),_cenY(0),_distance(),_property(-1) {}
	//! Constructor, pass the type id, source id, center X and center Y
  VisionEvent(EventTypeID_t tid, unsigned int sid, float cenX, float cenY) : EventBase(EventBase::visionEGID,sid,tid,0),_cenX(cenX),_cenY(cenY),_distance(),_property(-1) {}
  
  float getCenterX() const { return _cenX;} //!< returns the x coordinate
  VisionEvent& setCenterX(float cenX) { _cenX=cenX; return *this;} //!< sets the x coordinate
  
  float getCenterY() const { return _cenY;} //!< returns the y coordinate
  VisionEvent& setCenterY(float cenY) { _cenY=cenY; return *this;} //!< sets the y coordinate

  float getDistance() const { return _distance;} //!< returns the distance (not implemented)
  VisionEvent& setDistance(float distance) { _distance=distance; return *this;} //!< sets the distance

  int getProperty() const { return _property;} //!< returns the property
  VisionEvent& setProperty(int property) { _property=property; return *this;} //!< sets the property
      
 protected:
	float _cenX; //!< a value representing location in visual field - from -1 if on the left edge to 1 if it's on the right edge
	float _cenY; //!< a value representing location in visual field - from -1 if on the bottom edge to 1 if it's on the top edge
	float _distance; //!< distance from snout to object in millimeters.
  int _property; //!< some property, depending on the SID
};

#endif
