#ifndef INCLUDED_LocomotionEvent_h_
#define INCLUDED_LocomotionEvent_h_

#include "EventBase.h"

//! Gives updates regarding the current movement of the robot through the world
/*! An activate event will be sent when a potential source of motion is created,
 *  and a deactivate when it is destroyed.  Status events will be sent at any
 *  change of direction/speed.
 *
 *  The source ID field will hold a pointer to the MotionCommand doing the 
 *  locomotion, which you could theoretically use to get more information, but
 *  this is not 64-bit clean and is not recommended.  It should, however, be
 *  a unique identifier, so you can track the sources.
 */
class LocomotionEvent : public EventBase {
 public:

	//! @name Constructors

	//! constructor
	LocomotionEvent() : EventBase(),x(0),y(0),a(0) {}
	LocomotionEvent(EventGeneratorID_t gid, unsigned int sid, EventTypeID_t tid, unsigned int dur=0) : EventBase(gid,sid,tid,dur),x(0),y(0),a(0) {}
	LocomotionEvent(EventGeneratorID_t gid, unsigned int sid, EventTypeID_t tid, unsigned int dur, const std::string& n, double mag) : EventBase(gid,sid,tid,dur,n,mag),x(0),y(0),a(0) {}
	//@}

	//! Allows you to set the new X, Y, and A components
	LocomotionEvent& setXYA(float X, float Y, float A) {
		x=X;
		y=Y;
		a=A;
		return *this;
	}
	
	float x; //!< the new x component (body relative)
	float y; //!< the new y component (body relative)
	float a; //!< the new angular component (body relative)
};

/*! @file
 * @brief Defines LocomotionEvent, which gives updates regarding the current movement of the robot through the world
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name:  $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2003/02/07 07:33:48 $
 */

#endif
