#ifndef INCLUDED_SaveWalkControl_h
#define INCLUDED_SaveWalkControl_h

#include "ControlBase.h"
#include "Motion/MotionManager.h"
#include "Motion/WalkMC.h"
#include <string>

//! When activated, saves walk parameters to a file specified from cin
class SaveWalkControl : public ControlBase {
 public:
	//! constructor, pass the MC_ID of the walk you want to save
	SaveWalkControl(const string& n, MotionManager::MC_ID w) : ControlBase(n), walk_id(w) {}
	//! destructor
	virtual ~SaveWalkControl() {}

	//! when called, prompts on cin for file to save into -- will overwrite this file
	virtual ControlBase * activate(MotionManager::MC_ID display_id) {
    if(display_id!=MotionManager::invalid_MC_ID) {
      MMAccessor<LedMC> display(display_id);
      display.mc()->cset(FaceLEDMask,.5);
    }

		char cur[33];
		cout << "#> " << flush;
		cin >> cur;
		cout << endl;
		if(strlen(cur)>0) {
			WalkMC* walk = (WalkMC*)motman->checkoutMotion(walk_id);
			walk->save(cur);
			motman->checkinMotion(walk_id);
		}
		return NULL;
	}
	//! does nothing
	virtual void deactivate() {}

 protected:
	MotionManager::MC_ID walk_id; //!< MC_ID of walk to save from
};

/*! @file
 * @brief Defines SaveWalkControl, which when activated, saves walk parameters to a file specified from cin
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name:  $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2003/01/09 02:02:57 $
 */
#endif
