//-*-c++-*-
#ifndef INCLUDED_ProfilerCheckControl_h_
#define INCLUDED_ProfilerCheckControl_h_

#include "ControlBase.h"
#include "Shared/WorldState.h"

//! causes the WorldState::mainProfile and WorldState::motionProfile to display reports to cout
class ProfilerCheckControl : public ControlBase {
public:
	//! Constructor
	ProfilerCheckControl() : ControlBase("Profiler Check") {}

	//! Destructor
	~ProfilerCheckControl() {}
	
	//! Prints a report to cout
	virtual ControlBase * activate(MotionManager::MC_ID display) {
		if(display!=MotionManager::invalid_MC_ID) {
			//!@todo make the leds flash
		}
		printf("~~~ Main: ~~~\n%s",state->mainProfile.report().c_str());
		printf("~~~ Motion: ~~~\n%s",state->motionProfile.report().c_str());
		return NULL;
	}
};

/*! @file
 * @brief Defines ProfilerCheckControl, which causes the WorldState::mainProfile and WorldState::motionProfile to display reports to cout
 * @author ejt (Creator)
 *
 * $Author: alokl $
 * $Name:  $
 * $Revision: 1.1.1.1 $
 * $State: Exp $
 * $Date: 2002/09/30 18:19:48 $
 */

#endif
