//-*-c++-*-
#ifndef INCLUDED_MenuControl_h
#define INCLUDED_MenuControl_h

#include "ControlBase.h"
#include "Motion/MotionManager.h"
#include <vector>

//! Provides a simple menu system, allows a heirarchical menu structure
class MenuControl : public ControlBase {
 public:
	MenuControl() : ControlBase(), cur(0), options(), display_id(MotionManager::invalid_MC_ID), doRewrite(false) {} //!< constructor, see ControlBase::ControlBase()
	MenuControl(const std::string& n) : ControlBase(n), cur(0), options(), display_id(MotionManager::invalid_MC_ID), doRewrite(false) {} //!< constructor, see ControlBase::ControlBase(const std::string& n)
	virtual ~MenuControl() {
		deactivate();
		for(unsigned int i=0; i<options.size(); i++)
			delete options[i];
		options.clear();
	} //!< destructor

	virtual ControlBase * activate(MotionManager::MC_ID display);
	virtual void pause();
	virtual void refresh();
	virtual void deactivate();
	
	const vector<ControlBase*>& getSlots() const { return options; } //!< returns the vector of controls
	const char* getSlotName(unsigned int i) const; //!< returns the string that will appear in slot @a i
	unsigned int slotsSize() const { return options.size(); } //!< returns the number of options available
	void setSlot(unsigned int i,ControlBase* o); //!< sets @a i'th element of ::options to @a o
	void pushSlot(ControlBase* o); //!< sets next unused element of ::options to @a o

	virtual ControlBase* doSelect();
	virtual ControlBase* doNextItem();
	virtual ControlBase* doPrevItem();
	virtual ControlBase* doReadStdIn();
	
	virtual MotionManager::MC_ID getDisplay() { return display_id; } //!< returns display being used
	virtual MenuControl& setDisplay(MotionManager::MC_ID d) { display_id=d; return *this; } //!< sets display to use

	virtual ControlBase* getCurControl() { return options[cur]; } //!< returns the currently selected control
	
 protected:
#ifdef CONSOLE_VT100
	virtual void clearMenu();
#endif
	unsigned int cur; //!< index of current selection
	vector<ControlBase*> options; //!< vector of controls to select from
	MotionManager::MC_ID display_id; //!< LedMC to use for displaying selection
	bool doRewrite; //!< toggles using VT100 codes to reposition the cursor at the beginning of the menu
	                /*!< we don't always want to do this, any time someone else might have written to
									 *   the display we set this to false so we don't overwrite it. */
};

/*! @file
 * @brief Describes MenuControl, the main Control for the heirarchical menu structure
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name:  $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2002/11/30 22:50:26 $
 */

#endif
