#ifndef INCLUDED_LoadWalkControl_h
#define INCLUDED_LoadWalkControl_h

#include "ControlBase.h"
#include "Motion/WalkMC.h"
#include <string>

//! When activated, loads a set of walk parameters from a file read from cin
class LoadWalkControl : public ControlBase {
 public:
	//! constructor, pass the MC_ID of the WalkMC which you want to save
	LoadWalkControl(const string& n, MotionManager::MC_ID w) : ControlBase(n), walk_id(w) {}
	//! destructor
	virtual ~LoadWalkControl() {}

	//! prompts from cin for the file to load into the WalkMC specified in the constructor
	virtual ControlBase * activate(MotionManager::MC_ID display_id) {
		if(display_id!=MotionManager::invalid_MC_ID) {
      MMAccessor<LedMC> display(display_id);
      display.mc()->cset(FaceLEDMask,.5);
    }

		char cur[33];
		cout << "#> " << flush;
		cin >> cur;
		cout << endl;
		if(strlen(cur)>0) {
			WalkMC* walk = (WalkMC*)motman->checkoutMotion(walk_id);
			walk->load(cur);
			motman->checkinMotion(walk_id);
		}
		return NULL;
	}
	//! doesn't do anything
	virtual void deactivate() {}

 protected:
	MotionManager::MC_ID walk_id; //!< the MC_ID of the walk to load into
};

/*! @file
 * @brief Defines LoadWalkControl, which when activated, loads a set of walk parameters from a file read from cin.
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name:  $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2003/01/09 02:02:57 $
 */

#endif
