#ifndef INCLUDED_LoadPostureControl_h_
#define INCLUDED_LoadPostureControl_h_

#include "ControlBase.h"
#include "Motion/PostureMC.h"
#include <string>

//! Upon activation, loads a position from a file name read from cin (stored in ms/data/motion...)
class LoadPostureControl : public ControlBase {
 public:
	//! Constructor
	LoadPostureControl(const std::string& n) : ControlBase(n), display_id(MotionManager::invalid_MC_ID) {}
	//! Destructor
	virtual ~LoadPostureControl() {}

	virtual ControlBase* activate(MotionManager::MC_ID disp_id) {
		display_id=disp_id;
		return doReadStdIn();
	}

	ControlBase* doReadStdIn() {
		string filename;
		SharedMotion<PostureMC> post;
		if(display_id!=MotionManager::invalid_MC_ID) {
			MMAccessor<LedMC> display(display_id);
			display.mc()->cset(FaceLEDMask,.5);
		}
		cout << "Enter posture file to load (from /ms/data):" << endl;
		cout << "#> " << flush;
		cin >> filename;
		cout << endl;
		filename="/ms/data/motion/"+filename;
		post.MCBase()->LoadFile(filename.c_str());
		motman->addMotion(post,MotionCommand::kEmergencyPriority+1,true);
		return NULL;
	}

 private:
	MotionManager::MC_ID display_id; //!< the LEDMC to use to give feedback that it's waiting for console input
};

/*! @file
 * @brief Defines LoadPostureControl, which when activated, loads a position from a file name read from cin (stored in ms/data/motion...)
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name:  $
 * $Revision: 1.4 $
 * $State: Exp $
 * $Date: 2002/11/30 22:50:26 $
 */

#endif
