#include "EventLogger.h"
#include "Events/EventRouter.h"
#include "Motion/MMAccessor.h"
#include "Motion/LedMC.h"
#include "Controls/ValueEditControl.h"
#include <sstream>

EventLogger::EventLogger() : MenuControl("Event Logger"), logfile(), verbosity(0) {
	for(unsigned int i=0; i<EventBase::numEGIDs; i++) {
		string tmp=EventBase::EventGeneratorNames[i];
		pushSlot(new ControlBase(("[ ] "+tmp).c_str()));
	}
	pushSlot(NULL);
	pushSlot(new ValueEditControl<unsigned int>("Verbosity",&verbosity));
	pushSlot(new ControlBase("[X] Console Output"));
	pushSlot(new ControlBase("[ ] File Output"));
}

ControlBase* EventLogger::doSelect() {
	if(cur<EventBase::numEGIDs) {
		if(options[cur]->getName()[1]!=' ') {
			erouter->removeListener(this,(EventBase::EventGeneratorID_t)(cur));
			setStatus(cur,' ');
		} else {
			erouter->addListener(this,(EventBase::EventGeneratorID_t)(cur));
			setStatus(cur,'X');
		}
		refresh();
		return this;
		//	} else if(cur==EventBase::numEGIDs+1) {
		//		return MenuControl::doSelect();
	} else if(cur==EventBase::numEGIDs+2) {
		if(options[cur]->getName()[1]!=' ') {
			setStatus(cur,' ');
		} else {
			setStatus(cur,'X');
		}
	} else if(cur==EventBase::numEGIDs+3) {
		if(options[cur]->getName()[1]!=' ') {
			logfile.close();
			options[cur]->setName("[ ] File Output");
		} else {
			logfile.close();
			string file=getFilename();
			logfile.clear();
			cout << "Opening `"<<file<<"'"<<endl;
			logfile.open(file.c_str());
			if(!logfile.fail()) {
				setStatus(cur,'X');
				options[cur]->setName(options[cur]->getName()+string(": ")+file);
			}
		}
	}
	return MenuControl::doSelect();
}

//!sends all events received to stdout and/or logfile
void EventLogger::processEvent(const EventBase& event) {
	ostringstream logdata;
	logdata << event.getName();
	switch(event.getTypeID()) {
	case EventBase::activateETID:
		logdata << "\tA"; break;
	case EventBase::statusETID:
		logdata << "\tS"; break;
	case EventBase::deactivateETID:
		logdata << "\tD"; break;
	}
	if(verbosity>=1) {
		logdata << '\t' << event.getDuration() << '\t' << event.getTimeStamp();
		if(verbosity>=2) {
			logdata << '\t' << event.getMagnitude();
		}
	}
	
	if(options[EventBase::numEGIDs+2]->getName()[1]=='X')
		cout << "EVENT: " << logdata.str() << endl;
	if(logfile)
		logfile << logdata.str() << endl;
}

//!Prompts for a filename and returns the string
string EventLogger::getFilename() {
	string f;
	if(display_id!=MotionManager::invalid_MC_ID) {
		MMAccessor<LedMC> display(display_id);
		display.mc()->cset(FaceLEDMask,.5);
	}
	cout << "Enter filename:" << endl;
	cout << "#> " << flush;
	cin >> f;
	cout << endl;
	return f;
}

void EventLogger::setStatus(unsigned int i, char c) {
	string tmp=options[i]->getName();
	tmp[1]=c;
	options[i]->setName(tmp);
}


/*! @file
 * @brief Describes EventLogger, which allows logging of events to the console or a file
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name:  $
 * $Revision: 1.3 $
 * $State: Exp $
 * $Date: 2003/01/22 05:13:02 $
 */
