#include "ControlBase.h"
#include "Events/EventBase.h"
#include "Shared/WorldState.h"

/*! @fn ControlBase::activate(MotionManager::MC_ID)
 *  takes the id number of a LedMC which the control should use, maintained by Controller.  Controls share this display.
 *  @return a ControlBase pointer.  Return: @li @a this if the control should stay active (if it's not a one-shot command) @li @c NULL to return to parent @li other address to spawn a child control
 */


const EventBase ControlBase::nextItem(EventBase::buttonEGID,HeadFrButOffset,EventBase::deactivateETID,0);
const EventBase ControlBase::prevItem(EventBase::buttonEGID,HeadBkButOffset,EventBase::deactivateETID,0);
const EventBase ControlBase::nextItemFast(EventBase::buttonEGID,HeadFrButOffset,EventBase::statusETID,666);
const EventBase ControlBase::prevItemFast(EventBase::buttonEGID,HeadBkButOffset,EventBase::statusETID,666);
const EventBase ControlBase::selectItem(EventBase::buttonEGID,ChinButOffset,EventBase::deactivateETID,250);
const EventBase ControlBase::cancel(EventBase::buttonEGID,BackButOffset,EventBase::deactivateETID,250);

ControlBase * ControlBase::processControlEvent(const EventBase& e) {
	last_time=cur_time;
	cur_time=get_time();
	if(nextItem.sameGenSource(e)) {
		nextEv_val=e.getMagnitude();
		nextEv_dur=e.getDuration();
		if(nextEv_val==0 && prevEv_val==0)
			alreadyGotBoth=false;
		if(nextEv_val>.75 && prevEv_val>.75 && nextEv_dur<666 && prevEv_dur<666)
			if(alreadyGotBoth)
				return this;
			else {
				alreadyGotBoth=true;
				return doReadStdIn();
			}
		if(e.getTypeID()==nextItem.getTypeID() && e.getDuration()<666)
			return doNextItem();
		if(e.getTypeID()==nextItemFast.getTypeID() && e.getDuration()>666 && calcPulse(cur_time,last_time,static_cast<unsigned int>(50/e.getMagnitude())))
			return doNextItem();
	}
	if(prevItem.sameGenSource(e)) {
		prevEv_val=e.getMagnitude();
		prevEv_dur=e.getDuration();
		if(nextEv_val==0 && prevEv_val==0)
			alreadyGotBoth=false;
		if(nextEv_val>.75 && prevEv_val>.75 && nextEv_dur<666 && prevEv_dur<666)
			if(alreadyGotBoth)
				return this;
			else {
				alreadyGotBoth=true;
				return doReadStdIn();
			}
		if(e.getTypeID()==prevItem.getTypeID() && e.getDuration()<666)
			return doPrevItem();
		if(e.getTypeID()==prevItemFast.getTypeID() && e.getDuration()>666 && calcPulse(cur_time,last_time,static_cast<unsigned int>(50/e.getMagnitude())))
			return doPrevItem();
	}
	if(e.getDuration()>250) {
		if(e==selectItem)
			return doSelect();
		if(e==cancel)
			return doCancel();
	}
	return this;
}

/*! @file
 * @brief Defines ControlBase from which all items in the control system should inherit
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name:  $
 * $Revision: 1.3 $
 * $State: Exp $
 * $Date: 2002/11/30 22:50:26 $
 */
