//-*-c++-*-
#ifndef INCLUDED_XORBehavior_h_
#define INCLUDED_XORBehavior_h_

#include "../BehaviorBase.h"
#include "../../Motion/MotionManager.h"

class Model;

//! Tests the AI with learning xor
class XORBehavior : public BehaviorBase {
public:
	//! Creates a TDConfigModel, sets some parameters
	XORBehavior();

	//! destructor
	virtual ~XORBehavior() {}

	virtual void DoStart();
	virtual void DoStop();
	virtual void processEvent(const EventBase &event);

	//! will display the current status of the AI
	void dispStatus(void *);
	
	virtual const char* getName() const { return (isActive()?"#XORBehavior":"-XORBehavior"); }
	Model * getModel() { return model; } //!< returns the AI model being used

 protected:
	Model * model;                          //!< the ai model being used
  EventBase SID1;                         //!< stim 1
	EventBase SID2;                         //!< stim 2
	EventBase SIDr;                         //!< reward stim
	EventBase toggleLearn;                  //!< event mask to toggle learning
	EventBase cycle;                        //!< timer event mask for triggering an AI cycle
	EventBase endreward;                    //!< timer event mask for end of reward response
  MotionManager::MC_ID leds_id;           //!< led motioncommand
  MotionManager::MC_ID headpointer_id;    //!< headpointer motioncommand
  MotionManager::MC_ID tailwag_id;        //!< tailwagging motioncommand
	MotionManager::MC_ID dispos_id;         //!< disappointed posture
	MotionManager::MC_ID sitpos_id;         //!< sitting posture
	bool rew;                               //!< currently getting reward
};

/*! @file
 * @brief Describes XORBehavior, which does the XOR learning demo
 * @author ejt (Creator)
 *
 * $Author: alokl $
 * $Name:  $
 * $Revision: 1.1.1.1 $
 * $State: Exp $
 * $Date: 2002/09/30 18:19:49 $
 */

#endif
