#include "XORBehavior.h"
#include "../globals.h"
#include "../EventRouter.h"
#include "../../ai/TDConfigModel.h"
#include "../../headers/WorldState.h"
#include "../../Motion/MMAccessor.h"
#include "../../Motion/MotionCommands/PostureMC.h"
#include "../../Motion/MotionCommands/LedMC.h"
#include "../../Motion/MotionCommands/HeadPointerMC.h"
#include "../../Motion/MotionCommands/TailWagMC.h"

//! Converts radians to degrees
inline double RtoD(double rad) { return (rad/M_PI*180.0); }
//! Converts degrees to radians
inline double DtoR(double deg) { return (deg/180.0*M_PI); }

XORBehavior::XORBehavior()
	: BehaviorBase(),
		//SID1(EventBase::visionEGID,RedBallSID,EventBase::statusETID,0),
		//SID2(EventBase::visionEGID,BlueBallSID,EventBase::statusETID,0),
		//SIDr(EventBase::visionEGID,ThumbsupSID,EventBase::statusETID,0),
		SID1(EventBase::buttonEGID,ButtonSourceID::LFrPawSID,EventBase::statusETID,0),
		SID2(EventBase::buttonEGID,ButtonSourceID::RFrPawSID,EventBase::statusETID,0),
		SIDr(EventBase::buttonEGID,ButtonSourceID::ChinButSID,EventBase::statusETID,0),
		toggleLearn(EventBase::buttonEGID,ButtonSourceID::BackButSID,EventBase::deactivateETID,500),
		cycle(EventBase::timerEGID,0,EventBase::statusETID,50),
		endreward(EventBase::timerEGID,0,EventBase::statusETID,1200)
{
	model = new TDConfigModel();
	//	((TDConfigModel*)model)->SetMemorySlots(20);
	//	((TDConfigModel*)model)->SetMemoryTime(2000);
	((TDConfigModel*)model)->SetUniformSlots(true);
	((TDConfigModel*)model)->SetSlotVariance(10000);
	model->learn_rate=.05;
}

void XORBehavior::DoStart() {
	BehaviorBase::DoStart();
	leds_id=motman->addMotion(SharedMotion<LedMC>());
	headpointer_id=motman->addMotion(SharedMotion<HeadPointerMC>());
	tailwag_id=motman->addMotion(SharedMotion<TailWagMC>());
	dispos_id=motman->addMotion(SharedMotion<PostureMC>("/ms/config/motion/dispos.pos"),MotionCommand::kLowPriority);
	sitpos_id=motman->addMotion(SharedMotion<PostureMC>("/ms/config/motion/situp.pos"));
	erouter->addListener(this,SID1);
	erouter->addListener(this,SID2);
	erouter->addListener(this,SIDr);
	erouter->addListener(this,toggleLearn);
	//		erouter->addTimer(this,clock);
}

void XORBehavior::DoStop() {
	erouter->forgetListener(this);
	motman->removeMotion(leds_id);
	motman->removeMotion(headpointer_id);
	motman->removeMotion(tailwag_id);
	motman->removeMotion(dispos_id);
	motman->removeMotion(sitpos_id);
	BehaviorBase::DoStop();
}

void XORBehavior::processEvent(const EventBase &event) {

	if(event==SID1) {
		model->HandleEvent(Event("1",event.getTypeID()==EventBase::activateETID?1:0));
		MMAccessor<LedMC>(leds_id).mc()->set(BotLLEDMask,event.getTypeID()==EventBase::activateETID?1:0);

	} else if(event==SID2) {
		model->HandleEvent(Event("2",event.getTypeID()==EventBase::activateETID?1:0));
		MMAccessor<LedMC>(leds_id).mc()->set(BotRLEDMask,event.getTypeID()==EventBase::activateETID?1:0);

	} else if(event==SIDr) {			
		model->HandleEvent(Event("reward",event.getTypeID()==EventBase::activateETID?1:0));
		MMAccessor<LedMC>(leds_id).mc()->set(BotRLEDMask,event.getTypeID()==EventBase::activateETID?1:0);
		erouter->addTimer(this,endreward,false);

	} else if(event==toggleLearn) {
		static double prev;
		if(model->learn_rate==0)
			model->learn_rate=prev;
		else {
			prev=model->learn_rate;
			model->learn_rate=0;
		}

	} else if(event==cycle) {
		model->Cycle();
		double max=-1e6;
		unsigned int maxi=0;
		for(unsigned int i=0; i<Model::hist_len; i++)
			if(max<model->output_hist[1][i])
				max=model->output_hist[1][maxi=i];
		double min=max;
		for(unsigned int i=maxi; i<Model::hist_len; i++)
			if(min>model->output_hist[1][i])
				min=model->output_hist[1][i];
		/*			double output=(max-min)*3;

		if(output>1 || rew) { //doing CR
		if(get_time()>CRuntil) { //just starting
		{MMAccess<HeadPointerMC> point(headpointer_id); point.mc()->setJoints(lasttilt,lastpan,0)};
		{MMAccess<TailWagMC> wag(tailwag); wag.mc()->setActive(true)};
		}
		if(output>1)
		CRuntil=get_time()+1000;
		if(rew)
		CRuntil=get_time()+300;
		if(!rewardcame)
		disappointeduntil=CRuntil+2500;
		else
		disappointeduntil=0;
		} else if(get_time()>CRuntil) { //not doing CR
		{MMAccess<HeadPointerMC> point(headpointer_id); point.mc()->setJoints(tilt,pan,(get_time()+2000<disappointeduntil?DtoR(25):0)));
		{MMAccess<TailWagMC> wag(tailwag); wag.mc()->setActive(false)};
		static bool dispIsSet=false;
		if(get_time()<disappointeduntil && get_time()+2000>disappointeduntil) {
		if(!dispIsSet) {
		dispIsSet=true;
		PostureMC* disPos=(PostureMC*)motman->checkoutMotion(disPos_id);
		disPos->setPriority(MotionCommand::kHighPriority);
		motman->checkinMotion(disPos_id);
		}
		} else {
		if(dispIsSet) {
		dispIsSet=false;
					
		PostureMC* disPos=(PostureMC*)motman->checkoutMotion(disPos_id);
		disPos->setPriority(MotionCommand::kIgnoredPriority);
		motman->checkinMotion(disPos_id);
		}					
		}
		}
		//if(state->buttons[RFrPawOffset]) cout << "checkin..."<<flush;
		if(get_time()>CRuntil)
		rewardcame=false;
		bool hasact=model->HasActivation();
		if(!hasact && lastactive) {
		cout << "Model cleared" << endl;
		MMCALL(LedMC,leds_id,flash(TlBluLEDMask|TlRedLEDMask));
		}
		//if(state->buttons[RFrPawOffset]) cout << "lastactive..."<<flush;
		lastactive=hasact;
		LedMC * leds = (LedMC*)motman->checkoutMotion(leds_id);
		leds->set(TopBrLEDMask,output);
		leds->set(TopLLEDMask|TopRLEDMask,output>1);
		motman->checkinMotion(leds_id);
		//if(state->buttons[RFrPawOffset]) cout << "icdl-done..."<<flush;
		cycles++;
		*/
	}
}

void XORBehavior::dispStatus(void *) {
	model_time_t curTime= get_time();
	double max=-1e6,min=1e6;
	for(unsigned int i=0; i<Model::hist_len; i++) {
		if(max<model->output_hist[1][i])
			max=model->output_hist[1][i];
		if(min>model->output_hist[1][i])
			min=model->output_hist[1][i];
	}
	double output=(max-min)*3;
	cout << curTime/1000 << '\t' << '\t' << model->last_output << '\t' << model->last_err;
	cout << '\t' << output << ' ' << max << ' ' << min << endl;
}
	
/*! @file
 * @brief Implements XORBehavior, which does the XOR learning demo
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name:  $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2003/01/09 02:02:57 $
 */



		//<< ' ' << ((TDConfigModel*)model)->realStims.size() << ' ' << ((TDConfigModel*)model)->configUnits.size() << ' ' << model->GetStims().size() << endl;
		/*	for(unsigned int i=0; i<model->GetStims().size(); i++) {
				for(unsigned int j=0; j<model->GetStims()[i]->num_features; j++) {
				RWStimInfo* sptr = (RWStimInfo*)model->GetStims()[i]->feature[j];
				for(unsigned int k=0; k<sptr->GetMemorySlots(); k++)
				cout << sptr->CalcActivation(k) << '@' << sptr->GetAge(k) << ' ';
				cout << " / ";
				for(StimInfo::const_pres_list_it_t it=sptr->presentations.begin(); it!=sptr->presentations.end(); it++)
				cout << (*it).magnitude << '@' << (*it).time << ' ';
				cout << endl;
				}
				}
				cout << endl;*/


/*
		static double tilt=-DtoR(30),pan=0;
		static double lasttilt=0,lastpan=0;
		static unsigned int CRuntil=0;
		static unsigned int disappointeduntil=0;
		static bool rewardcame=false;
		static bool lastactive=false;
		bool rew=false;
		if(event.longerThan(toggleLearn)) {
			if(model->learn_rate==0)
				model->learn_rate=0.05;
			else
				model->learn_rate=0;
			MMAccessor<LedMC> leds(leds_id);
			leds.mc()->flash(FaceLEDMask);
		}
		if(event.getTypeID()!=EventBase::statusETID) {
			if((*it)->getSourceID()==SID1) {
				model->HandleEvent(Event("1",event.getTypeID()==EventBase::activateETID?1:0));
				MMAccessor<LedMC> leds(leds_id);
				leds.mc()->set(BotLLEDMask,event.getTypeID()==EventBase::activateETID?1:0);
			} else if((*it)->getSourceID()==SID2) {
				model->HandleEvent(Event("2",event.getTypeID()==EventBase::activateETID?1:0));
				MMAccessor<LedMC> leds(leds_id);
				leds.mc()->set(BotRLEDMask,event.getTypeID()==EventBase::activateETID?1:0);
			} else if((*it)->getSourceID()==SIDr) {
				//						rew=((*it)->getTypeID()==EventBase::activateETID);
				model->HandleEvent(Event("reward",event.getTypeID()==EventBase::activateETID?1:0));
				MMAccessor<LedMC> leds(leds_id);
				leds.mc()->set(MidLLEDMask|MidRLEDMask,event.getTypeID()==EventBase::activateETID?1:0);
			}
			if(event.getTypeID()==EventBase::deactivateETID) {
				tilt=-DtoR(30);
				pan=0;
			}
		} else {
			VisionEvent* ve = (VisionEvent*)&event;
			tilt=state->outputs[HeadOffset+TiltOffset]-ve->getCenterY()/100.0*M_PI/7.0;
			pan=state->outputs[HeadOffset+PanOffset]-ve->getCenterX()/100.0*M_PI/7.0;
			if(tilt<DtoR(-20))
				tilt=DtoR(-20);
			if(tilt>DtoR(70))
				tilt=DtoR(70);
			if(pan>DtoR(80))
				pan=DtoR(80);
			if(pan<DtoR(-80))
				pan=DtoR(-80);
			if((*it)->getSourceID()==SIDr) {
				lasttilt=tilt;
				lastpan=pan;
				rewardcame=true;
				rew=true;
			}
		}
		model->Cycle();
		double max=-1e6;
		unsigned int maxi=0;
		for(unsigned int i=0; i<Model::hist_len; i++)
			if(max<model->output_hist[1][i])
				max=model->output_hist[1][maxi=i];
		double min=max;
		for(unsigned int i=maxi; i<Model::hist_len; i++)
			if(min>model->output_hist[1][i])
				min=model->output_hist[1][i];
		double output=(max-min)*3;
		if(output>1 || rew) { //doing CR
			if(get_time()>CRuntil) { //just starting
				{MMAccess<HeadPointerMC> point(headpointer_id); point.mc()->setJoints(lasttilt,lastpan,0)};
				{MMAccess<TailWagMC> wag(tailwag); wag.mc()->setActive(true)};
			}
			if(output>1)
				CRuntil=get_time()+1000;
			if(rew)
				CRuntil=get_time()+300;
			if(!rewardcame)
				disappointeduntil=CRuntil+2500;
			else
				disappointeduntil=0;
		} else if(get_time()>CRuntil) { //not doing CR
			{MMAccess<HeadPointerMC> point(headpointer_id); point.mc()->setJoints(tilt,pan,(get_time()+2000<disappointeduntil?DtoR(25):0)));
			{MMAccess<TailWagMC> wag(tailwag); wag.mc()->setActive(false)};
			static bool dispIsSet=false;
			if(get_time()<disappointeduntil && get_time()+2000>disappointeduntil) {
				if(!dispIsSet) {
					dispIsSet=true;
					PostureMC* disPos=(PostureMC*)motman->checkoutMotion(disPos_id);
					disPos->setPriority(MotionCommand::kHighPriority);
					motman->checkinMotion(disPos_id);
				}
			} else {
				if(dispIsSet) {
					dispIsSet=false;
					
					PostureMC* disPos=(PostureMC*)motman->checkoutMotion(disPos_id);
					disPos->setPriority(MotionCommand::kIgnoredPriority);
					motman->checkinMotion(disPos_id);
				}					
			}
		}
		//if(state->buttons[RFrPawOffset]) cout << "checkin..."<<flush;
		if(get_time()>CRuntil)
			rewardcame=false;
		bool hasact=model->HasActivation();
		if(!hasact && lastactive) {
			cout << "Model cleared" << endl;
			MMCALL(LedMC,leds_id,flash(TlBluLEDMask|TlRedLEDMask));
		}
		//if(state->buttons[RFrPawOffset]) cout << "lastactive..."<<flush;
		lastactive=hasact;
		LedMC * leds = (LedMC*)motman->checkoutMotion(leds_id);
		leds->set(TopBrLEDMask,output);
		leds->set(TopLLEDMask|TopRLEDMask,output>1);
		motman->checkinMotion(leds_id);
		//if(state->buttons[RFrPawOffset]) cout << "icdl-done..."<<flush;
		cycles++;
*/
