#include "StartupBehavior.h"

#include "Behaviors/Controller.h"

#include "Controls/BatteryCheckControl.h"
#include "Controls/BehaviorActivatorControl.h"
#include "Controls/BehaviorSwitchControl.h"
//#include "Controls/LoadAIControl.h"
#include "Controls/LoadPostureControl.h"
#include "Controls/LoadWalkControl.h"
#include "Controls/MenuControl.h"
#include "Controls/MCValueEditControl.h"
#include "Controls/ProfilerCheckControl.h"
#include "Controls/RunSequenceControl.h"
//#include "Controls/SaveAIControl.h"
#include "Controls/SavePostureControl.h"
#include "Controls/SaveWalkControl.h"
#include "Controls/ValueEditControl.h"
#include "Controls/ValueSetControl.h"

#include "Controls/EventLogger.h"

#include "Behaviors/BatteryMonitorBehavior.h"
//#include "Behaviors/CameraBehavior.h"
#include "Behaviors/ChaseBallBehavior.h"
#include "Behaviors/StareAtBallBehavior.h"
#include "Behaviors/FollowHeadBehavior.h"
#include "Behaviors/HeadLevelBehavior.h"
//#include "Behaviors/XORBehavior.h"
#include "Behaviors/LocalizerBehavior.h"
#include "Behaviors/EvtRptBehavior.h"

#include "StateMachine/PaceTargetsMachine.h"
#include "StateMachine/WalkToTargetMachine.h"
#include "StateMachine/BanditMachine.h"
//#include "StateMachine/WorldModel2Behavior.h"

#include "Motion/SharedMotion.h"
#include "Motion/MotionCommand.h"
#include "Motion/PostureMC.h"
#include "Motion/EmergencyStopMC.h"
#include "Motion/PIDMC.h"
#include "Motion/MotionSequenceMC.h"
#include "Motion/MMAccessor.h"

StartupBehavior::StartupBehavior() : BehaviorBase(), spawned(), stop_id(MotionManager::invalid_MC_ID), pid_id(MotionManager::invalid_MC_ID) {}

StartupBehavior::~StartupBehavior() {}

void StartupBehavior::DoStart() {
	BehaviorBase::DoStart();
	//This will "fade" in the PIDs so the joints don't jerk to full power, also looks cooler
	pid_id=motman->addMotion(SharedMotion<PIDMC>(0),MotionCommand::kEmergencyPriority+1,false);
	//also, pause before we start fading in, PIDs take effect right away, before the emergencystop is picked up
	erouter->addTimer(this,0,4*FrameTime*NumFrames,true);

	//This is the default emergency stop
	const SharedMotion<EmergencyStopMC> stop;
	stop->LoadFile("/ms/data/motion/liedown.pos"); //This *should* be replaced by the current position, but just in case, better than setting everything to 0's
	stop->setStopped(true); //if you want to start off paused
	stop_id=motman->addMotion(stop);
	
	//This is for the menu system
	Controller * controller=new Controller;
	controller->setEStopID(stop_id);
	SetupController(*controller);
	controller->DoStart();
	spawned.push_back(controller);
	
	//This displays the current battery conditions
	//	const SharedMotion<LedMC> led; //! @todo LedMC's don't support autopruning yet, it should for uses like this, or could the one in Controller
	BatteryCheckControl batchk;
	batchk.activate(MotionManager::invalid_MC_ID);
	//	batchk.activate(motman->addMotion(led,true));
	batchk.deactivate();

	//This will close the mouth so it doesn't look stupid
	//Now done by setting the emergency stop directly in processEvent, but left as demo code:
	/*	const SharedMotion<PostureMC> closemouth;
			closemouth->setJointCmd(MouthOffset,outputRanges[MouthOffset][MaxRange],1);
			motman->addMotion(closemouth,MotionCommand::kEmergencyPriority+2,true);
	*/
}

void StartupBehavior::DoStop() {
	for(vector<BehaviorBase*>::iterator it=spawned.begin(); it!=spawned.end(); it++)
		(*it)->DoStop();
	BehaviorBase::DoStop();
}

/*!Uses a few timer events at the beginning to fade in the PID values*/
void StartupBehavior::processEvent(const EventBase&) {
	static unsigned int start_time=-1U;
	const unsigned int tot_time=2047; //if this is set to 2048, i sometimes get funny errors: [oid:80000034,prio:1] AGRMSDriver::SetGain() : 0x0A IS USED FOR GAIN SHIFT VALUE.
	if(start_time==-1U) { //first time
		start_time=get_time();
		MMAccessor<EmergencyStopMC>(stop_id)->takeSnapshot(); //take new snapshot with hopefully valid data
	} else {
		float power=(get_time()-start_time)/(float)tot_time;
		if(power>1)
			power=1;
		{ MMAccessor<PIDMC>(pid_id)->setAllPowerLevel(power); }
		{ MMAccessor<EmergencyStopMC>(stop_id)->setJointCmd(MouthOffset,outputRanges[MouthOffset][MaxRange],1); }
	}
	if((get_time()-start_time)>=tot_time) {
		erouter->removeTimer(this);
		motman->removeMotion(pid_id);
		pid_id=MotionManager::invalid_MC_ID;
	}
}

/*class WalkToPinkBallFactory : public Factory<WalkToTargetMachine> {
public:
	static WalkToTargetMachine* construct() { return new WalkToTargetMachine(VisionEventNS::PinkBallSID); }
	};*/

void
StartupBehavior::SetupController(Controller& controller) {
	cout << "CONTROLLER-INIT..." << flush;
	stack< MenuControl* > mcsetup;
	{
		mcsetup.push(new MenuControl("Root Control"));
		mcsetup.top()->pushSlot(new MenuControl("Mode Switch"));
		{ 
			mcsetup.push((MenuControl*)mcsetup.top()->getSlots().back());
			BehaviorSwitchControlBase::BehaviorGroup * bg = new BehaviorSwitchControlBase::BehaviorGroup();
			//put behaviors here
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<FollowHeadBehavior>("Follow Head",bg,false));
			//			mcsetup.top()->pushSlot(new BehaviorSwitchControl<CameraBehavior>("Camera",bg,false));
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<LocalizerBehavior>("Localizer",bg,false));
			/*			XORBehavior* xorbeh=new XORBehavior(); //i make other controls which reference xorbeh below
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<XORBehavior>("AI Control",xorbeh,bg));
			{ // I don't necessarily like this method of adding sub menus to control behavior parameters, but you can do it quickly. (cleaner to subclass the behavior, have it add its own)
				mcsetup.push((MenuControl*)mcsetup.top()->getSlots().back());
				mcsetup.top()->pushSlot(new BehaviorActivatorControl("Toggle",(BehaviorSwitchControlBase*)mcsetup.top()));
				mcsetup.top()->pushSlot(new ValueSetControl<double>("Enable learning (0.035)",&xorbeh->getModel()->learn_rate,0.035));
				mcsetup.top()->pushSlot(new ValueSetControl<double>("Disable learning",&xorbeh->getModel()->learn_rate,0));
				mcsetup.top()->pushSlot(new LoadAIControl("Load AI",xorbeh->getModel()));
				mcsetup.top()->pushSlot(new SaveAIControl("Save AI",xorbeh->getModel()));
				mcsetup.pop();
			}
			*/
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<ChaseBallBehavior>("ChaseBallBehavior",bg,false));
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<StareAtBallBehavior>("StareAtBallBehavior",bg,false));
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<PaceTargetsMachine>("PaceTargetsMachine",bg,false));
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<WalkToTargetMachine,Factory1Arg<WalkToTargetMachine,VisionEventNS::VisionSourceID_t,VisionEventNS::PinkBallSID> >("WalkToPinkBall",bg,false));
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<BanditMachine>("BanditMachine",bg,false));
			//			mcsetup.top()->pushSlot(new BehaviorSwitchControl<WorldModel2Behavior>("WorldModel2Behavior",bg,false));
			mcsetup.pop();
		}
		mcsetup.top()->pushSlot(new MenuControl("Background Behaviors"));
		{ 
			mcsetup.push((MenuControl*)mcsetup.top()->getSlots().back());
			mcsetup.top()->pushSlot((new BehaviorSwitchControl<BatteryMonitorBehavior>("Battery Monitor",false))->start());
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<EvtRptBehavior>("EvtRptBehavior",false));
			
			HeadLevelBehavior* levelbeh=new HeadLevelBehavior();
			mcsetup.top()->pushSlot(new BehaviorSwitchControl<HeadLevelBehavior>("Head Level",levelbeh,NULL));
			
			mcsetup.pop();
		}
		mcsetup.top()->pushSlot(new BatteryCheckControl());
		mcsetup.top()->pushSlot(new ProfilerCheckControl());
		mcsetup.top()->pushSlot(new EventLogger());
		
		mcsetup.top()->pushSlot(new LoadPostureControl("Load Posture"));
		mcsetup.top()->pushSlot(new SavePostureControl("Save Posture"));
		mcsetup.top()->pushSlot(new RunSequenceControl<255>("Run Motion Sequence"));
	}
	if(mcsetup.size()!=1)
		cout << "*** WARNING *** menu setup stack more than one or empty" << endl;
	controller.setRoot(mcsetup.top());
	cout << "DONE" << endl;
}
