//-*-c++-*-
#ifndef INCLUDED_StareAtBallBehavior_h_
#define INCLUDED_StareAtBallBehavior_h_

#include "BehaviorBase.h"
#include "Motion/MotionManager.h"

//! A simple behavior to chase after any objects seen by the vision system
class StareAtBallBehavior : public BehaviorBase {
public:
	//!constructor
	StareAtBallBehavior()
		: BehaviorBase(), headpointer_id(MotionManager::invalid_MC_ID)
	{}
	//!destructor
	virtual ~StareAtBallBehavior() {}

	//! adds a headpointer and a listens for vision events
	virtual void DoStart();

	//! removes motion commands and stops listening
	virtual void DoStop();

	//! sets the head to point at the object and sets the body to move where the head points
	virtual void processEvent(const EventBase& event);
			
	virtual const char* getName() const { return (isActive()?"#StareAtBallBehavior":"-StareAtBallBehavior"); } //!< returns name of behavior

protected:
	MotionManager::MC_ID headpointer_id; //!< a HeadPointerMC object
};

/*! @file
 * @brief Describes StareAtBallBehavior, which runs around after whatever the dog sees
 * @author tss (Creator)
 *
 * $Author: tss $
 * $Name:  $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2002/11/03 19:32:42 $
 */

#endif
