#ifndef INCLUDED_LocalizerBehavior_h_
#define INCLUDED_LocalizerBehavior_h_

#include "Shared/WorldState.h"
#include "BehaviorBase.h"
#include "Motion/MotionManager.h"
#include "Motion/MMAccessor.h"
#include "Motion/SharedMotion.h"
#include "Events/VisionEvent.h"
#include "Events/EventRouter.h"
#include "WorldModel/WorldModel.h"
#include "Motion/HeadPointerMC.h"
#include "Vision/Vision.h"
#include "math.h"

inline double DtoR(double deg) { return (deg/180.0*M_PI); }

//! Will localize when asked to
/*! Press the head button to localize */
class LocalizerBehavior : public BehaviorBase {
public:
  //! just sets up the variables
  LocalizerBehavior() :
    BehaviorBase(),
    localize_click(EventBase::buttonEGID,HeadFrButOffset,
									 EventBase::deactivateETID,250),
    headpointer_id(MotionManager::invalid_MC_ID)
  {}

  //! calls DoStop() if isActive()
  ~LocalizerBehavior() { }

  //! Register for events and creates and adds two motion commands - a walker and a tail wag
  virtual void DoStart() {
    BehaviorBase::DoStart();
    //register for events and timers
    erouter->addListener(this,localize_click);
    headpointer_id = motman->addMotion(SharedMotion<HeadPointerMC>());
    erouter->addListener(this,EventBase::visionEGID);
    vision->enableEvents(VisionEventNS::RedBallSID,2);
    vision->enableEvents(VisionEventNS::PinkBallSID,2);
//    vision->enableEvents(VisionEventNS::RedBallSID,3);
  }

  //! Does nothing
  virtual void DoStop() {
    vision->disableEvents(VisionEventNS::RedBallSID);
    vision->disableEvents(VisionEventNS::PinkBallSID);
    erouter->forgetListener(this);
    erouter->forgetListener(this);
    motman->removeMotion(headpointer_id);
    BehaviorBase::DoStop();
  }

  //! Handles event processing
  /*! After every sensor update, set head in direction of tail */
  virtual void processEvent(const EventBase& e) {
    static float horiz=0, vert=0;
    if (e.equalOrLongerThan(localize_click))
      wmodel->localize();
    else if (wmodel->_locState==WorldModel::loc_disabled && e.getGeneratorID()==EventBase::visionEGID && e.getTypeID()==EventBase::statusETID) {
      horiz=static_cast<const VisionEvent*>(&e)->getCenterX();
      vert=static_cast<const VisionEvent*>(&e)->getCenterY();

      double tilt=state->outputs[HeadOffset+TiltOffset]-vert*M_PI/7.5;
      double pan=state->outputs[HeadOffset+PanOffset]-horiz*M_PI/6;
      if(tilt<DtoR(-70))
	      tilt=DtoR(-70);
      if(tilt>DtoR(40))
	      tilt=DtoR(40);
      if(pan>DtoR(80))
	      pan=DtoR(80);
      if(pan<DtoR(-80))
	      pan=DtoR(-80);
      HeadPointerMC * headpointer= (HeadPointerMC*)motman->checkoutMotion(headpointer_id);
      headpointer->setJoints(tilt,pan,0);
      motman->checkinMotion(headpointer_id);
      if (fabs(horiz)<0.15 && fabs(vert)<0.15) {
	wmodel->reportObject(e.getSourceID());
      }
    } else if (wmodel->_locState==WorldModel::loc_disabled && e.getGeneratorID()==EventBase::visionEGID && e.getTypeID()==EventBase::deactivateETID) {
      wmodel->removeObject(e.getSourceID());
    }
  }

  virtual const char* getName() const { return (isActive()?"#LocalizerBehavior":"-LocalizerBehavior"); } //!< returns name of behavior
 protected:
  const EventBase localize_click; //!< event mask for localizing (head button)
  MotionManager::MC_ID headpointer_id; //!< used to look for markers when needed
};

#endif
