//-*-c++-*-
#ifndef INCLUDED_HeadLevelBehavior_h_
#define INCLUDED_HeadLevelBehavior_h_

#include "BehaviorBase.h"
#include "Motion/MotionManager.h"
#include "Motion/MMAccessor.h"
#include "Motion/HeadPointerMC.h"
#include "Motion/PIDMC.h"
#include <math.h>

//! Tests the head leveling code of HeadPointerMC
class HeadLevelBehavior : public BehaviorBase {
 public:
	//! constructor
	HeadLevelBehavior()
		: BehaviorBase(),
			head_release(EventBase::buttonEGID,HeadFrButOffset,EventBase::activateETID,0),
			head_lock(EventBase::buttonEGID,HeadFrButOffset,EventBase::deactivateETID,0),
			head(),
			head_id(MotionManager::invalid_MC_ID)
	{
		head.getRegion()->AddReference();
	}
	//! destructor
	virtual ~HeadLevelBehavior() {
		head.getRegion()->RemoveReference();
	}

	virtual void DoStart() {
		BehaviorBase::DoStart();
		head.MCBase()->setJoints(state->outputs[HeadOffset+TiltOffset],state->outputs[HeadOffset+PanOffset],state->outputs[HeadOffset+RollOffset]);
		head.MCBase()->setMode(HeadPointerMC::GravityRelative,true);
		head_id=motman->addMotion(head);
		erouter->addListener(this,head_lock);
		erouter->addListener(this,head_release);
	}

	virtual void DoStop() {
		erouter->forgetListener(this);
		motman->removeMotion(head_id);
		head.MCBase()->setMode(HeadPointerMC::BodyRelative,false);
		BehaviorBase::DoStop();
	}

	virtual void processEvent(const EventBase &event) {
		if(event==head_lock) {
			for(unsigned int i=HeadOffset; i<HeadOffset+NumHeadJoints; i++)
				head.MCBase()->setJointValueFromMode((TPROffset_t)(i-HeadOffset),state->outputs[i],HeadPointerMC::BodyRelative);
			motman->addMotion(SharedMotion<PIDMC>(HeadOffset,HeadOffset+NumHeadJoints,1));
		} else if(event==head_release) {
			motman->addMotion(SharedMotion<PIDMC>(HeadOffset,HeadOffset+NumHeadJoints,0));
		} else
			ASSERTRET(false,"received unasked for event "<<event.getName());
	}
	virtual const char* getName() const { return (isActive()?"#HeadLevelBehavior":"-HeadLevelBehavior"); } //!< returns name of behavior

 protected:
	const EventBase head_release; //!< event mask for releasing head (chin button down)
	const EventBase head_lock;    //!< event mask for locking head (chin button up)
	const SharedMotion<HeadPointerMC> head; //!< might as well just hang on to the whole memory region and reuse it, we can peek for most of our stuff
	MotionManager::MC_ID head_id; //!< MCID of headpointer
};

/*! @file
 * @brief Defines HeadLevelBehavior, which a prototypes head leveler
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name:  $
 * $Revision: 1.4 $
 * $State: Exp $
 * $Date: 2003/02/23 09:58:06 $
 */

#endif 
