//-*-c++-*-
#ifndef INCLUDED_EvtRptBehavior_h_
#define INCLUDED_EvtRptBehavior_h_

#include "BehaviorBase.h"

//! A simple behavior to test event reports
class EvtRptBehavior : public BehaviorBase {
public:
	//!constructor
	EvtRptBehavior()
		: BehaviorBase()
	{}
	//!destructor
	virtual ~EvtRptBehavior() {}

	//! Subscribes to various events
	virtual void DoStart();

	//! Cancels event subscriptions
	virtual void DoStop();

	//! prints out data on subscribed events
	virtual void processEvent(const EventBase& event);
			
	virtual const char* getName() const { return (isActive()?"#EvtRptBehavior":"-EvtRptBehavior"); } //!< returns name of behavior
};

/*! @file
 * @brief Describes EvtRptBehavior, which couts information about events it sees
 * @author tss (Creator)
 */

#endif
